function Ramais(db){

    this.db = db;
    this.ramais = {};

    this.loadRamais = function(){
        var self = this;

        var sql = "SELECT * FROM vm50_ramais";

        this.db.query(sql, function(err, rows){
            if(err) return;

            for(var i = 0; i < rows.length; i++){
                self.ramais[rows[i].ramal.trim()] = {};
                self.ramais[rows[i].ramal.trim()] = rows[i];
            }
        });
    };

    this.isRamal = function(ramal){
        ramal = this.extractRamal(ramal);

        if(this.ramais[ramal]) return true;
        else return false;
    };

    this.extractRamal = function(ramal){
        if(ramal.indexOf("SIP/") > -1){
            var aux = "";
            if(ramal.indexOf("-") > -1){
                aux = ramal.split("-");
                aux = aux[0].split("/");
            } else aux = ramal.split("/");

            ramal = aux[1];
        }

        return ramal.trim();
    }

    this.getExtensionState = function(ami, ramal, callback){
        ami.action({
            "ACTION": "ExtensionState",
            "Context": "blf",
            "Exten": ramal
        }, callback);
    };
}

module.exports = Ramais;
