<?php
include_once "../classes/WebSocket.php";
include_once "../config.php";
include_once "../classes/syonet.class.php";
include_once "../pbx/modulos/pbx.modu.php";
include_once "../cc/classes/agentes.class.php";
include_once '../libs/log4php/Logger.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

/**
 * Definição de variáveis globais
 **/
$agentPa = array();
$lig_entrada = array();
$lig_saida = array();
$dadosLigacoes = array();
$msgVoiceMail = "";
$log = Logger::getLogger('Pami.ClientImpl'); //Inicia o log com nome da aplicação

// Setup include path.
ini_set(
	'include_path',
	implode(
		PATH_SEPARATOR,
		array(
			implode(DIRECTORY_SEPARATOR, array('..', 'libs', 'PAMI')),
			'../libs/log4php', '../libs/',
			ini_get('include_path'),
		)
	)
);

//Cria o objeto do WebSocket aceitando conexão a partir de qualquer ip mas somente na porta específica
$ws = new WebSocket('0.0.0.0', $PortaWebSocket);
//Cria o objeto da classe Syonet
$syonet = new Syonet();
//Cria o objeto monitor do pbx caso tenha necessidade
if ($Ws_Chamadas_Espera) {
	$pbxMonitor = new Monitor();
}

//Preenche o agentPa
$Agen = new Agentes; //Objeto agente
$agents = $Agen->lista_agentes();
if(count($agents) <= 0) return;

for($i = 0; $i < count($agents[0]); $i++){
    if($agents[0][$i]['situacao'] != "NLogado"){
        $agentPa[$agents[0][$i]['login']]['ramal'] = $agents[0][$i]['ramal'];
        $agentPa[$agents[0][$i]['login']]['context'] = $agents[0][$i]['contexto'];
    }
}

$ws->open();

require_once '../libs/PAMI/Autoloader/Autoloader.php'; // Include PAMI autoloader.
\PAMI\Autoloader\Autoloader::register(); // Call autoloader register for PAMI autoloader.
use PAMI\Client\Impl\ClientImpl as PamiClient;
use PAMI\Message\Action\ExtensionStateAction;
use PAMI\Message\Event\EventMessage;

/**
 * Configura os dados (ip, porta, usuário, senha...) para conexão no AMI do Asterisk.
 * @var array
 */
$options = array(
	'log4php.properties' => realpath(__DIR__) . DIRECTORY_SEPARATOR . 'log4php.properties',
	'host' => $HostAsterisk,
	'port' => 5038,
	'username' => 'pami',
	'secret' => 'PAMI',
	'connect_timeout' => 10,
	'read_timeout' => 30,
	'scheme' => 'tcp://', // try tls://
);

//Cria o objeto da classe PamiClient passando por parametro os dados para conexão.
try {
	$pamiClient = new PamiClient($options);
	// Abre uma conexão com o AMI do Asterisk
	$pamiClient->open();
} catch (Exception $e) {
	echo "Não foi possível conectar no host " . $options['host'] . ":" . $options['port'] . "\n";
	echo "Verifique as configurações de conexão em: vdt/websocket/ws.modu.php\n\n";
	$log->debug("Não foi possível conectar no host " . $options['host'] . ":" . $options['port'] . "\n");
	$log->debug("Verifique as configurações de conexão em: vdt/websocket/ws.modu.php\n\n");
}

//Configura o listener de quando o Asterisk manda um evento
$pamiClient->registerEventListener(function (EventMessage $event) {
	Global $ws, $agentPa;
	$msg = null;
	if ($event->getName() == "AntennaLevel") {
		$msg = tratarAntennaLevel($event);
		$json = json_encode($msg);
		$ws->send_message($json);
	} else if ($event->getName() == "ExtensionStatus") {
		$msg = tratarExtensionStatus($event);
		$json = json_encode($msg);
		$ws->send_message($json);
	} else if ($event->getName() == "Agentcallbacklogin") {
		$msg = tratarAgentcallbacklogin($event);
		$json = json_encode($msg);
		$ws->send_message($json);
	} else if ($event->getName() == "Agentcallbacklogoff") {
		$msg = tratarAgentcallbacklogoff($event);
		$json = json_encode($msg);
		$ws->send_message($json);
	} else if ($event->getName() == "QueueMemberPaused") {
		$msg = tratarQueueMemberPaused($event);
		$json = json_encode($msg);
		$ws->send_message($json);
	} else if ($event->getName() == "QueueMemberStatus") {
		$msg = tratarQueueMemberStatus($event);
		$json = json_encode($msg);
	} else if ($event->getName() == "Dial") {
		$msg = tratarDial($event);
		$json = json_encode($msg);
		$ws->send_message($json);
	} else if ($event->getName() == "Newstate") {
		$msg = tratarNewstate($event);
		if (is_array($msg)) {
			$json = json_encode($msg);
			$ws->send_message($json);
		}
	} else if ($event->getName() == "Hangup") {
		$msg = tratarHangup($event);
		if (is_array($msg)) {
			$json = json_encode($msg);
			$ws->send_message($json);
		}
	} else if ($event->getName() == "Newexten") {
		$msg = tratarNewexten($event);
		if (is_array($msg)) {
			$json = json_encode($msg);
			$ws->send_message($json);
		}
	} else if ($event->getName() == "Unlink") {
		$msg = tratarUnlink($event);
		if (is_array($msg)) {
			$json = json_encode($msg);
			$ws->send_message($json);
		}
	} else if ($event->getName() == "QueueCallerAbandon") {
		tratarQueueCallerAbandon($event);
	} else if ($event->getName() == "MessageWaiting") {
		tratarMessageWaiting($event);
	} else {
		/*$msg["evento"] = $event->getName();
			$msg["rawContent"] = $event->getRawContent();
			if(is_array($msg)){
				$json = json_encode($msg);
				$ws->send_message($json);
		*/
	}
});

//Recebe as mensagens que chegam pelo WebSocket e trata de acordo com o necessário
$running = true;
$countA = 0;
while (true) {
	$msg = $ws->check_new_messages();

	if ($msg != "") {
		$ws->send_message("Nova mensagem: " . $msg);
	}

	if ($Ws_Chamadas_Espera) {
		if ($countA == 1000) {
			//echo "Sending QueueStatus\r\n";
			$queueStatus = lista_chamadas_espera_todas();
			//echo print_r($queueStatus, true);
			$countA = 0;
			$msg['tipo'] = "QueueStatus";
			$msg['queueStatus'] = $queueStatus;
			$json = json_encode($msg);
			//echo $json;
			$ws->send_message($json);

		} else {
			$countA++;
		}

	}

	try {
		$pamiClient->process();
	} catch (Exception $e) {
		echo "Não foi possível encontrar o processo do pami. Possível desconexão...\n";
		echo "Tentando reconectar...\n\n";
		$log->debug("Não foi possível encontrar o processo do pami. Possível desconexão...\n");
		$log->debug("Exception: " . $e);
		$log->debug("Tentando reconectar...\n\n");
		pcntl_exec("/etc/init.d/websocket", array("restart"));
	}
	usleep(1000);
}
$pamiClient->close();
$ws->close();

/**
 * Funções
 **/

/**
 * Trata o evento de nível de sinal das antenas de celular
 * @param  EventMessage $event Recebe um objeto do tipo EventMessage
 * @return Array        Retorna um array com as informações importantes para serem enviadas aos clientes conectados no
 * WebSocket
 */
function tratarAntennaLevel($event) {
	$msg["tipo"] = $event->getName();
	$msg["channel"] = $event->getChannel();
	$msg["signal"] = $event->getSignal();
	return $msg;
}

/**
 * Trata os eventos de ExtensionStatus, onde geralmente é quando um ramal muda de status
 * @param  EventMessage $event Recebe um objeto do tipo EventMessage
 * @return Array        Retorna um array com as informações importantes para serem enviadas aos clientes conectados no
 * Websocket
 */
function tratarExtensionStatus($event) {
	$msg["tipo"] = $event->getName();
	$msg["exten"] = $event->getExtension();
	$msg["context"] = $event->getContext();
	$msg["hint"] = $event->getHint();
	$msg["status"] = $event->getStatus();
	return $msg;
}

/**
 * Trata os eventos de quando um agente faz o login em alguma fila do Asterisk.
 * @param  EventMessage $event Recebe um objeto do tipo EventMessage
 * @return Array        Retorna um array com as informações importantes para serem enviadas aos clientes conectados no
 * Websocket
 */
function tratarAgentcallbacklogin($event) {
	Global $agentPa;
	$msg["tipo"] = $event->getName();
	$msg["agent"] = $event->getAgent();
	$msg["loginchan"] = $event->getLoginchan();
	$dadosAg = explode("@", $msg["loginchan"]);
	$agentPa[$event->getAgent()]["ramal"] = $dadosAg[0];
	$agentPa[$event->getAgent()]["context"] = $dadosAg[1];
	return $msg;
}

/**
 * Trata os eventos de quando um agente faz o logout de alguma fila do Asterisk.
 * @param  EventMessage $event Recebe um objeto do tipo EventMessage
 * @return Array        Retorna um array com as informações importantes para serem enviadas aos clientes conectados no
 * Websocket
 */
function tratarAgentcallbacklogoff($event) {
	Global $agentPa;
	$msg["tipo"] = $event->getName();
	$msg["agent"] = $event->getAgent();
	$msg["reason"] = $event->getReason();
	$msg["loginchan"] = $event->getLoginchan();
	$msg["logintime"] = $event->getLogintime();
	if (isset($agentPa[$event->getAgent()])) {
		unset($agentPa[$event->getAgent()]);
	}

	return $msg;
}

/**
 * Trata os eventos de quando um agente muda de status em alguma fila do Asterisk.
 * @param  EventMessage $event Recebe um objeto do tipo EventMessage
 * @return Array        Retorna um array com as informações importantes para serem enviadas aos clientes conectados no
 * Websocket
 */
function tratarQueueMemberStatus($event) {
	$msg["tipo"] = $event->getName();
	$msg["queue"] = $event->getQueue();
	$msg["location"] = $event->getLocation();
	$msg["memberName"] = $event->getMemberName();
	$msg["membership"] = $event->getMembership();
	$msg["penalty"] = $event->getPenalty();
	$msg["callsTaken"] = $event->getCallsTaken();
	$msg["status"] = $event->getStatus();
	$msg["pause"] = $event->getPause();
	return $msg;
}

/**
 * Trata os eventos de quando um agente entra em pausa em alguma fila do Asterisk.
 * @param  EventMessage $event Recebe um objeto do tipo EventMessage
 * @return Array        Retorna um array com as informações importantes para serem enviadas aos clientes conectados no
 * Websocket
 */
function tratarQueueMemberPaused($event) {
	Global $pamiClient, $agentPa;
	$msg["tipo"] = $event->getName();
	$msg["queue"] = $event->getQueue();
	$msg["location"] = $event->getLocation();
	$msg["memberName"] = $event->getMemberName();
	$msg["paused"] = $event->getPaused();
	$dadosAg = explode("/", $event->getMemberName());

	if (isset($agentPa[$dadosAg[1]])) {
		$msg["ramal"] = $agentPa[$dadosAg[1]]["ramal"];
		$action = new ExtensionStateAction($agentPa[$dadosAg[1]]["ramal"], "blf");
		$response = $pamiClient->send($action);
		if ($response->getKey("response") == "Success") {
			$msg["statusRamal"] = $response->getKey("status");
		}
	}
	return $msg;
}

/**
 * Trata os eventos de ligação do Asterisk
 * @param  EventMessage $event Recebe um objeto do tipo EventMessage
 * @return Array        Retorna um array com as informações importantes para serem enviadas aos clientes conectados no
 * Websocket
 */
function tratarDial($event) {
	Global $lig_entrada;
	$destino = explode("-", $event->getDestination());
	$dest = explode("/", $destino[0]);
	if ($dest[0] != "SIP") {
		return;
	}

	$msg["tipo"] = $event->getName();
	$msg["channel"] = $event->getChannel();
	$msg["destination"] = $event->getDestination();
	$msg["callerId"] = $event->getKey("CallerID");
	$msg["callerIdNum"] = $event->getCallerIDNum();
	$msg["callerIdName"] = $event->getCallerIDName();
	$msg["uniqueId"] = $event->getUniqueID();
	$msg["destUniqueId"] = $event->getDestUniqueID();
	$msg["dialString"] = $event->getDialString();
	$msg["dialStatus"] = $event->getDialStatus();
	$lig_entrada[$destino[0]] = $msg;
	return $msg;
}

/**
 * Trata os eventos Newstate do Asterisk.
 * @param  EventMessage $event Recebe um objeto do tipo EventMessage
 * @return Array        Retorna um array com as informações importantes para serem enviadas aos clientes conectados no
 * Websocket
 */
function tratarNewstate($event) {
	Global $lig_entrada;
	$channel = explode("-", $event->getChannel());
	if (isset($lig_entrada[$channel[0]])) {
		$msg["tipo"] = $event->getName();
		$msg["destination"] = $lig_entrada[$channel[0]]["destination"];
		$msg["callerId"] = $lig_entrada[$channel[0]]["callerId"];
		$msg["callerIdNum"] = $lig_entrada[$channel[0]]["callerIdNum"];
		$msg["callerIdName"] = $lig_entrada[$channel[0]]["callerIdName"];
		$msg["uniqueId"] = $event->getUniqueID();
		$msg["state"] = $event->getKey("state");
		$msg["time"] = time();
		return $msg;
	}
	return "";
}

/**
 * Trata os eventos de quando tem um Hangup no Asterisk.
 * @param  EventMessage $event Recebe um objeto do tipo EventMessage
 * @return Array        Retorna um array com as informações importantes para serem enviadas aos clientes conectados no
 * Websocket
 */
function tratarHangup($event) {
	Global $lig_entrada, $lig_saida, $dadosLigacoes, $syonet, $msgVoiceMail, $tipoEnvioSyonet;
	if (isset($dadosLigacoes["uniqueId"][$event->getUniqueID()])) {
		if (isset($dadosLigacoes["uniqueId"][$event->getUniqueID()]["application"]) && ($dadosLigacoes["uniqueId"][$event->getUniqueID()]["application"] == "VoiceMail" || $dadosLigacoes["uniqueId"][$event->getUniqueID()]["application"] == "Queue") && isset($dadosLigacoes["uniqueId"][$event->getUniqueID()]["fila"])) {
			$numero = $dadosLigacoes["uniqueId"][$event->getUniqueID()]["origem"];
			$fila = $dadosLigacoes["uniqueId"][$event->getUniqueID()]["fila"];
			$gravacao = $dadosLigacoes["uniqueId"][$event->getUniqueID()]["gravacao"];
			list($gravacao, $tmp) = explode(".wav49", $gravacao);
			$gravacao = $gravacao . ".WAV";
			list($tmp, $tmp, $data, $horario) = explode("-", $gravacao);
			$data = substr($data, 0, 2) . "/" . substr($data, 2, 2) . "/" . substr($data, 4, 4);
			$horario = substr($horario, 0, 2) . ":" . substr($horario, 2, 2) . ":" . substr($horario, 4, 2);
			$deixou_mensagem = false;
			if ($dadosLigacoes["uniqueId"][$event->getUniqueID()]["application"] == "VoiceMail" && $msgVoiceMail != "") {
				if (file_exists($msgVoiceMail)) {
					copy($msgVoiceMail, $dadosLigacoes["uniqueId"][$event->getUniqueID()]["gravacao"]);
					echo "VoiceMail: " . $msgVoiceMail . "\nCopiado para: " . $dadosLigacoes["uniqueId"][$event->getUniqueID()]["gravacao"] . "\n";
					$deixou_mensagem = true;
				}
				$msgVoiceMail = "";
			}
			if ($dadosLigacoes["uniqueId"][$event->getUniqueID()]["application"] == "VoiceMail") {
				if ($tipoEnvioSyonet == 0 || $tipoEnvioSyonet == 1) {
					$syonet->informarCaixaPostal($fila, $numero, $gravacao, $data, $horario, $deixou_mensagem);
				}

			} else {
				if ($tipoEnvioSyonet == 0 || $tipoEnvioSyonet == 2) {
					$syonet->informarDesistencia($fila, $numero, $gravacao, $data, $horario);
				}

			}
		} else {
			if (isset($dadosLigacoes["uniqueId"][$event->getUniqueID()])) {
				unset($dadosLigacoes["uniqueId"][$event->getUniqueID()]);
			}
		}
	}
	//Limpa o array dadosLigacoes para não ficar ocupando espaço na memória
	if (isset($dadosLigacoes["uniqueId"][$event->getUniqueID()])) {
		unset($dadosLigacoes["uniqueId"][$event->getUniqueID()]);
	}

	/*echo "\nQuantidade de ligações no array: ".count($dadosLigacoes["uniqueId"])."\n";
		    if(count($dadosLigacoes["uniqueId"]) > 0){
		        echo print_r($dadosLigacoes["uniqueId"], true)."\n";
	*/

	$channel = explode("-", $event->getChannel());
	if (isset($lig_entrada[$channel[0]])) {
		$msg["tipo"] = $event->getName();
		$msg["direction"] = "entrada";
		$msg["channel"] = $event->getChannel();
		$msg["callerId"] = $lig_entrada[$channel[0]]["callerId"];
		$msg["uniqueId"] = $event->getUniqueID();
		unset($lig_entrada[$channel[0]]);
		return $msg;
	}
	if (isset($lig_saida[$channel[0]])) {
		$msg["tipo"] = $event->getName();
		$msg["direction"] = "saida";
		$msg["channel"] = $event->getChannel();
		$msg["extension"] = $lig_saida[$channel[0]]["extension"];
		$msg["uniqueId"] = $event->getUniqueID();
		unset($lig_saida[$channel[0]]);
		return $msg;
	}
	return "";
}

/**
 * Trata os eventos de Newexten do Asterisk.
 * @param  EventMessage $event Recebe um objeto do tipo EventMessage
 * @return Array        Retorna um array com as informações importantes para serem enviadas aos clientes conectados no
 * Websocket
 */
function tratarNewexten($event) {
	Global $lig_saida, $dadosLigacoes;
	if ($event->getExtension() == "h") {
		return "";
	}

	//Separa algumas informações de acordo com o uniqueId
	if ($event->getApplication() == "MixMonitor") {
		$dadosNomeLigacao = explode("-", $event->getApplicationData());
		//echo print_r($dadosNomeLigacao, true);
		if (count($dadosNomeLigacao) == 6 && $dadosNomeLigacao[5] == "VM.wav49") {
			$app = $event->getApplicationData();
			$fileName = substr($app, 22);
			$dadosNome = explode("-", $fileName);
			$dadosLigacoes["uniqueId"][$event->getUniqueID()]["gravacao"] = $app;
			$dadosLigacoes["uniqueId"][$event->getUniqueID()]["origem"] = $dadosNome[0];
			$dadosLigacoes["uniqueId"][$event->getUniqueID()]["destino"] = $dadosNome[1];
		} else if (count($dadosNomeLigacao) == 4) {
			$app = $event->getApplicationData();
			$fileName = substr($app, 22);
			$dadosNome = explode("-", $fileName);
			$dadosLigacoes["uniqueId"][$event->getUniqueID()]["gravacao"] = $app;
			$dadosLigacoes["uniqueId"][$event->getUniqueID()]["origem"] = $dadosNome[0];
			$dadosLigacoes["uniqueId"][$event->getUniqueID()]["destino"] = $dadosNome[1];
		}
	}
	//Trata os eventos de VoiceMail
	//if($event->getApplication() == "VoiceMail") {
	if (isset($dadosLigacoes["uniqueId"][$event->getUniqueID()])) {
		$dadosLigacoes["uniqueId"][$event->getUniqueID()]["application"] = $event->getApplication();
	}
	//}

	$channel = explode("-", $event->getChannel());
	$msg["tipo"] = $event->getName();
	$msg["channel"] = $event->getChannel();
	$msg["context"] = $event->getContext();
	$msg["extension"] = $event->getExtension();
	$msg["time"] = time();
	if (!isset($lig_saida[$channel[0]])) {
		$lig_saida[$channel[0]] = $msg;
		return $msg;
	}
	return "";
}

/**
 * Trata os eventos de Unlink do Asterisk.
 * @param  EventMessage $event Recebe um objeto do tipo EventMessage
 * @return Array        Retorna um array com as informações importantes para serem enviadas aos clientes conectados no
 * Websocket
 */
function tratarUnlink($event) {
	Global $lig_saida;
	$channel1 = explode("-", $event->getChannel1());
	if (isset($lig_saida[$channel1[0]])) {
		$msg["tipo"] = $event->getName();
		$msg["direction"] = "saida";
		$msg["channel"] = $event->getChannel1();
		$msg["extension"] = $lig_saida[$channel1[0]]["extension"];
		unset($lig_saida[$channel1[0]]);
		return $msg;
	}
	return "";
}

/**
 * Trata os eventos de quando uma ligação abandona uma fila no Asterisk.
 * @param  EventMessage $event Recebe um objeto do tipo EventMessage
 * @return Array        Retorna um array com as informações importantes para serem enviadas aos clientes conectados no
 * Websocket
 */
function tratarQueueCallerAbandon($event) {
	Global $dadosLigacoes;
	$dadosLigacoes["uniqueId"][$event->getUniqueID()]["fila"] = $event->getQueue();
}

function tratarMessageWaiting($event) {
	Global $msgVoiceMail;
	list($mailBox, $context) = explode("@", $event->getMailbox());
	$msg = "/var/spool/asterisk/voicemail/" . $context . "/" . $mailBox . "/INBOX/msg" . str_pad(($event->getNew() - 1), 4, "0", STR_PAD_LEFT) . ".wav";
	$msgVoiceMail = $msg;
}
?>
